type Props = {
  width?: string;
  height?: string;
  fill?: string;
};
export function Send({ width = "56", height = "56", fill = "#EACAAC" }: Props) {
  return (
    <svg
      width={width}
      height={height}
      viewBox="0 0 56 56"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        opacity="0.4"
        fillRule="evenodd"
        clipRule="evenodd"
        d="M26.4983 30.0846C26.5284 30.2211 26.5629 30.3744 26.6012 30.5434C26.772 31.2968 27.0221 32.3606 27.3399 33.6066C27.9741 36.0925 28.8836 39.3272 29.9773 42.2688C30.524 43.7395 31.1241 45.1568 31.7679 46.3795C32.4032 47.5865 33.1191 48.6773 33.922 49.4345C34.7228 50.1896 35.7964 50.7727 37.0377 50.4775C38.2062 50.1994 39.1242 49.2252 39.8769 47.9211C42.3229 43.6833 45.5707 34.447 47.9341 25.8622C49.1213 21.5506 50.1002 17.3504 50.6501 13.9635C50.9248 12.2727 51.0972 10.7564 51.1296 9.51696C51.1565 8.49459 51.1518 7.33296 50.6583 6.40609C50.5491 6.20139 50.3816 6.03381 50.1769 5.92477C49.2499 5.43113 48.0884 5.42656 47.0659 5.45332C45.8264 5.48575 44.3102 5.65816 42.6195 5.93275C39.2324 6.48274 35.0324 7.4616 30.7207 8.64875C22.136 11.0124 12.8996 14.2599 8.66199 16.706C7.35789 17.4588 6.38359 18.3767 6.10557 19.5452C5.81019 20.7866 6.39343 21.8601 7.14855 22.661C7.90553 23.4638 8.99646 24.1797 10.2035 24.8153C11.4262 25.459 12.8435 26.0589 14.3141 26.6056C17.2558 27.6993 20.4905 28.6088 22.9764 29.243C24.2223 29.5608 25.2863 29.8109 26.0395 29.9817C26.2085 30.0202 26.362 30.0545 26.4983 30.0846Z"
        fill={fill}
      />
      <path
        fill-rule="evenodd"
        clip-rule="evenodd"
        d="M44.4791 13.0733C45.1625 13.7568 45.1625 14.8648 44.4791 15.5482L31.5715 28.4557C30.8881 29.1392 29.78 29.1392 29.0966 28.4557C28.4131 27.7723 28.4131 26.6642 29.0966 25.9808L42.0041 13.0733C42.6875 12.3899 43.7956 12.3899 44.4791 13.0733Z"
        fill={fill}
      />
    </svg>
  );
}
