type Props = {
  width?: string;
  height?: string;
  fill?: string;
};
export function Plus({ width = "56", height = "56", fill = "#EACAAC" }: Props) {
  return (
    <svg
      width={width}
      height={height}
      viewBox="0 0 56 56"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        opacity="0.4"
        fillRule="evenodd"
        clipRule="evenodd"
        d="M28.5835 5.36108C10.9459 5.36108 4.69727 11.6098 4.69727 29.2474C4.69727 46.8851 10.9459 53.1337 28.5835 53.1337C46.2188 53.1337 52.4698 46.8851 52.4698 29.2474C52.4698 11.6098 46.2188 5.36108 28.5835 5.36108Z"
        fill={fill}
      />
      <path
        d="M30.332 30.9976H36.9307C37.8967 30.9976 38.6807 30.2136 38.6807 29.2476C38.6807 28.2816 37.8967 27.4976 36.9307 27.4976H30.332V20.9082C30.332 19.9422 29.548 19.1582 28.582 19.1582C27.616 19.1582 26.832 19.9422 26.832 20.9082V27.4976H20.2334C19.2674 27.4976 18.4834 28.2816 18.4834 29.2476C18.4834 30.2136 19.2674 30.9976 20.2334 30.9976H26.832V37.5869C26.832 38.5529 27.616 39.3369 28.582 39.3369C29.548 39.3369 30.332 38.5529 30.332 37.5869V30.9976Z"
        fill={fill}
      />
    </svg>
  );
}
