import { forwardRef } from "react";
import * as React from "react";

type WrapperProps = {
  as?: React.ElementType;
  className?: string;
  children?: React.ReactNode;
} & React.HTMLAttributes<HTMLElement>;

export const Wrapper = forwardRef<HTMLElement, WrapperProps>(
  ({ as = "div", className, children, ...props }, ref) => {
    const Component = as as React.ElementType;

    return (
      <Component
        ref={ref}
        className={[
          "mx-auto max-w-7xl px-3 md:px-5 lg:px-10 xl:px-0",
          className,
        ]
          .filter(Boolean)
          .join(" ")}
        {...props}
      >
        {children}
      </Component>
    );
  }
);

Wrapper.displayName = "Wrapper";
