import React from "react";

type Props = {
  placeholder: string;
  labelText?: string;
  formObject?: any;
};

function Textarea({ placeholder, labelText, formObject, ...rest }: Props) {
  return (
    <label className="input-label">
      <span>{labelText}</span>
      <textarea {...formObject} placeholder={placeholder} {...rest}></textarea>
    </label>
  );
}

export default Textarea;
