import React from 'react';

interface TabContentProps {
    activeTabId: number;
    content: { id: number; content: React.ReactNode }[];
}

const TabContent: React.FC<TabContentProps> = ({ activeTabId, content }) => {
    const activeContent = content.find(c => c.id === activeTabId);

    return (
activeContent ? activeContent.content : 'Select a tab to see the content'
    );
};

export default TabContent;
