import { useDarkMode } from "@/shared/hooks/useDarkMode";
import { Eye, EyeSlash } from "iconsax-react";
import { ComponentProps, useState } from "react";

type Props = {
  placeholder?: string;
  labelText?: string;
  type?: string;
  formObject?: any;
  errors?: any;
  badge?: string;
  containerClass?: string;
} & ComponentProps<"input">;

function InputField({
  placeholder,
  labelText,
  type,
  containerClass,
  formObject,
  badge,
  errors,
  ...rest
}: Props) {
  const [passwordType, setPasswordType] = useState(false);
  const isDark = useDarkMode();

  const changeTypeHandler = () => {
    setPasswordType(() => !passwordType);
  };
  return (
    <label className={`input-label ${containerClass}`}>
      {labelText && (
        <span className="pr-2 inline-block text-sm">{labelText}</span>
      )}
      <input
        type={passwordType ? "text" : type}
        placeholder={placeholder}
        {...formObject}
        {...rest}
      />
      {type === "password" && (
        <span
          onClick={changeTypeHandler}
          className={`absolute left-4 ${labelText ? "top-8" : "top-3"}`}
        >
          {!passwordType ? (
            <>
              {isDark ? (
                <Eye variant="Bulk" size={25} color="var(--color-gray-800)" />
              ) : (
                <Eye variant="Bulk" size={25} color="#35393c" />
              )}
            </>
          ) : (
            <>
              {isDark ? (
                <EyeSlash
                  variant="Bulk"
                  size={25}
                  color="var(--color-gray-800)"
                />
              ) : (
                <EyeSlash variant="Bulk" size={25} color="#35393c" />
              )}
            </>
          )}
        </span>
      )}
      {badge && (
        <span
          className={`absolute left-4 text-gray ${
            labelText ? "top-10" : "top-3"
          }`}
        >
          {badge}
        </span>
      )}
      {errors && <span className="text-danger text-xs">{errors?.message}</span>}
    </label>
  );
}

export default InputField;
