import React, { AnchorHTMLAttributes } from "react";

type LinkProps = {
  children: React.ReactNode;
  className?: string;
  color?:
    | "primary"
    | "light-primary"
    | "dark"
    | "default"
    | "success"
    | "light-success"
    | "light-gray"
    | "danger"
    | "white"
    | "light-danger";
  variant?: "text" | "contained" | "outline" | "link";
  size?: "icon" | "sm-icon" | "md" | "sm" | "lg";
} & AnchorHTMLAttributes<HTMLAnchorElement>;

function Chip({
  children,
  className = "",
  color = "primary",
  variant = "contained",
  size = "md",
  ...rest
}: LinkProps) {
  const variantClasses = {
    primary:
      variant === "contained"
        ? "bg-primary-main text-white hover:bg-primary-hover border-primary-main hover:border-primary-hover"
        : variant === "outline"
        ? "text-primary-main bg-white border-primary-main"
        : variant === "text"
        ? "bg-white text-primary-main border-white"
        : "bg-white underline text-primary-main border-white",
    "light-primary": "bg-primary-bg border-primary-bg text-primary-main",
    dark:
      variant === "contained"
        ? "bg-secondary-text text-white hover:bg-secondary-hover border-secondary-text hover:border-secondary-hover"
        : variant === "outline"
        ? "text-secondary-text bg-white border-secondary-text"
        : variant === "text"
        ? "bg-white text-secondary-text border-white"
        : "bg-white underline text-secondary-text border-white",
    danger:
      variant === "contained"
        ? "bg-red-600 text-white hover:bg-red-500 border-red-600 hover:border-red-500"
        : variant === "outline"
        ? "text-red-600 bg-white border-red-600"
        : variant === "text"
        ? "bg-white text-red-600 border-white"
        : "bg-white underline text-red-600 border-white",
    success: "bg-green-500 text-white hover:bg-green-600",
    default: "bg-gray-200 text-gray-900 border-gray-200 hover:bg-gray-300",
    "light-success": "bg-green-500/30 border-green-500/20 text-dark-green-1000",
    "light-danger": "bg-red-600/20 border-red-500/20 text-red-800",
    "light-gray": "bg-gray-200 border-gray-200 text-gray-1000",
    white:
      variant === "contained"
        ? "bg-white text-gold-700 border-white"
        : variant === "outline"
        ? "text-dark-blue-800 bg-white border-dark-blue-800"
        : variant === "text"
        ? "bg-white text-gold-700 border-white"
        : "bg-white underline textgold-700 border-white",
  };

  const sizeClasses = {
    icon: "size-[52px]",
    "sm-icon": "size-8",
    sm: "h-9 text-xs",
    md: "h-10 text-sm",
    lg: "h-11 text-sm",
  };

  const chipClass = `flex justify-center border items-center gap-2 ${
    size === "sm-icon" ? "p-2" : "px-3"
  } rounded-[50px] ${variantClasses[color]} ${sizeClasses[size]} ${className}`;

  return (
    <span className={chipClass} {...rest}>
      {children}
    </span>
  );
}

export default Chip;
