import LinkCM from "@/shared/components/link";
import { Typography } from "@/shared/components/typography";
import { Wrapper } from "@/shared/components/wrapper";
import { ChevronLeft } from "@/shared/icons/ChevronLeft";
import { Plus } from "@/shared/icons/Plus";

function StepsSection() {
  return (
    <section className="bg-secondary-active py-24 text-gray-200">
      <Wrapper as="section">
        <div className="flex justify-between items-center">
          <Typography as="h2" variant="H2B">
            مراحل فروش چوب در آرتاپان
          </Typography>
          <LinkCM href="" className="group hidden sm:flex">
            ثبت مناقصه و فروش چوب
            <span className="flex items-center">
              <span className="inline-block w-4 h-0.5 bg-white -ml-1 transition-all duration-300 group-hover:w-7"></span>
              <ChevronLeft />
            </span>
          </LinkCM>
        </div>
        <Typography variant="H5R" as="p" className="mt-10 w-full! leading-9">
          توضیحات در این بخش نمایش داده می شود تا کاربر راحت متوجه فرآیند
          شودتوضیحات در این بخش نمایش داده می شود تا کاربر راحت متوجه فرآیند
          شود. توضیحات در این بخش نمایش داده می شود تا کاربر راحت متوجه فرآیند
          شودتوضیحات در این بخش نمایش داده می شود تا کاربر راحت متوجه فرآیند
          شودتوضیحات در این بخش نمایش داده می شود تا کاربر راحت متوجه فرآیند
        </Typography>
        <LinkCM href="" className="group sm:hidden mt-5">
          ثبت مناقصه و فروش چوب
          <span className="flex items-center">
            <span className="inline-block w-4 h-0.5 bg-white -ml-1 transition-all duration-300 group-hover:w-7"></span>
            <ChevronLeft />
          </span>
        </LinkCM>
        <div className="flex flex-wrap mt-5 sm:mt-16">
          <div className="w-full min-[575px]:w-1/2 lg:w-1/4 flex flex-col gap-5 justify-end py-3 ps-5 sm:pe-16 step">
            <Plus />
            <Typography variant="H5B" as="h4">
              ثبت مناقصه
            </Typography>
            <Typography variant="H5R" as="p">
              در گام اول نیاز هست تا مناقصه را ثبت نمایید
            </Typography>
          </div>
          <div className="w-full min-[575px]:w-1/2 lg:w-1/4 flex flex-col gap-5 justify-end py-3 ps-5 sm:pe-16 step">
            <Plus />
            <Typography variant="H5B" as="h4">
              ارسال بار به آرتاپان
            </Typography>
            <Typography variant="H5R" as="p">
              با تائید مناقصه، بار چوب خود را برای آرتاپان ارسال کنید
            </Typography>
          </div>
          <div className="w-full min-[575px]:w-1/2 lg:w-1/4 flex flex-col gap-5 justify-end py-3 ps-5 sm:pe-16 step">
            <Plus />
            <Typography variant="H5B" as="h4">
              دریافت بار در آرتاپان
            </Typography>
            <Typography variant="H5R" as="p">
              بار در کارخانه آرتاپان توسط پرسنل تحویل گرفته می شود
            </Typography>
          </div>
          <div className="w-full min-[575px]:w-1/2 lg:w-1/4 flex flex-col gap-5 justify-end py-3 ps-5 sm:pe-16 step">
            <Plus />
            <Typography variant="H5B" as="h4">
              تسویه مناقصه
            </Typography>
            <Typography variant="H5R" as="p">
              پس از تحویل بار مبلغ مناقصه به حساب شما واریز می گردد
            </Typography>
          </div>
        </div>
      </Wrapper>
    </section>
  );
}

export default StepsSection;
