import LinkCM from "@/shared/components/link";
import { Typography } from "@/shared/components/typography";
import { Wrapper } from "@/shared/components/wrapper";
import { ChevronLeft } from "@/shared/icons/ChevronLeft";
import Logo from "@/shared/icons/Logo";
import Image from "next/image";
import Link from "next/link";

function Footer() {
  return (
    <footer className="">
      <Wrapper className="flex gap-7">
        <Image
          src="/f3.png"
          alt="footer image 1"
          width={340}
          height={280}
          className="min-w-0 flex-1 lg:flex-none lg:w-[30%] h-[280px] object-cover rounded-md hidden sm:block"
        />
        <Image
          src="/f2.png"
          alt="footer image 1"
          width={340}
          height={280}
          className="min-w-0 flex-1 h-[280px] object-cover rounded-md"
        />
        <Image
          src="/f1.png"
          alt="footer image 1"
          width={340}
          height={280}
          className="min-w-0 flex-1 lg:flex-none w-[30%] h-[280px] object-cover rounded-md hidden md:block"
        />
      </Wrapper>
      <section className="footer flex flex-col pt-60 items-center gap-8 -mt-[140px]">
        <Typography variant="H2B" className="text-secondary-text">
          همین حالا مناقصه خود را ثبت کنید
        </Typography>
        <LinkCM href="" className="group">
          ثبت مناقصه و فروش چوب
          <span className="flex items-center">
            <span className="inline-block w-4 h-0.5 bg-white -ml-1 transition-all duration-300 group-hover:w-7"></span>
            <ChevronLeft />
          </span>
        </LinkCM>
      </section>
      <section className="bg-linear-to-b from-[#090908] to-black text-white ">
        <Wrapper className="py-16 flex justify-between items-center">
          <div className="space-y-3">
            <div>
              <Typography variant="H5M">شماره تماس: </Typography>
              <Link href="tel:0218588">
                <Typography variant="H5R" className="inline-block pr-1">
                  021-8588
                </Typography>
              </Link>
            </div>
            <div>
              <Typography variant="H5M">پست الکترونیک : </Typography>
              <Link href="mailto:info@artamdf.ir">
                <Typography variant="H5R" className="inline-block pr-1">
                  info@artamdf.ir
                </Typography>
              </Link>
            </div>
            <div>
              <Typography variant="H5M">آدرس : </Typography>
              <Typography
                as="address"
                variant="H5R"
                className="inline-block pr-1"
              >
                تهران، خیابان ولیعصر، بلوار میرداماد، جنب آزمایشگاه مسعود، پلاک
                472
              </Typography>
            </div>
          </div>
          <Logo />
        </Wrapper>
        <Wrapper as="section" className="pt-5 pb-10 license">
          <Typography variant="BR" className="text-center block">
            کلیه حقوق مادی و معنوی این وب‌سایت متعلق به گروه آرتا است.
          </Typography>
        </Wrapper>
      </section>
    </footer>
  );
}

export default Footer;
